<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'tiny_recordrtc', language 'en'.
 *
 * @package    tiny_recordrtc
 * @copyright  2022 Stevani Andolo <stevani@hotmail.com.au>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['allowedtypes'] = 'Recording type';
$string['allowedtypes_desc'] = 'Which types of recording can be made in the TinyMCE editor? In addition to this setting, there are two capabilities which control access to recording options.';
$string['attachrecording'] = 'Attach recording';
$string['audioandvideo'] = 'Audio and video';
$string['audiobitrate'] = 'Audio bitrate';
$string['audiobitrate_desc'] = 'Quality of audio recording (larger number means higher quality).';
$string['audiobuttontitle'] = 'Record audio';
$string['audiotimelimit'] = 'Audio time limit';
$string['audiotimelimit_desc'] = 'Maximum recording length for audio clips.';
$string['audiotitle'] = 'Record audio';
$string['confirm_yes'] = 'Yes';
$string['discard_desc'] = 'There is a recording in progress. Do you want to stop the recording?';
$string['discard_title'] = 'Close confirmation';
$string['gumabort'] = 'Something happened which prevented the webcam/microphone from being used.';
$string['gumabort_title'] = 'Something happened';
$string['gumnotallowed'] = 'You must allow the browser access to the webcam/microphone.';
$string['gumnotallowed_title'] = 'Wrong permissions';
$string['gumnotfound'] = 'No input device detected.';
$string['gumnotfound_title'] = 'Device missing';
$string['gumnotreadable'] = 'Something is preventing the browser from accessing the webcam/microphone.';
$string['gumnotreadable_title'] = 'Hardware error';
$string['gumnotsupported'] = 'Your browser doesn\'t support recording over an insecure connection.';
$string['gumnotsupported_title'] = 'No support for insecure connection';
$string['gumoverconstrained'] = 'The current webcam/microphone can\'t produce a stream with the required constraints.';
$string['gumoverconstrained_title'] = 'Problem with constraints';
$string['gumsecurity'] = 'Your browser doesn\'t support recording over an insecure connection.';
$string['gumsecurity_title'] = 'No support for insecure connection';
$string['gumtype'] = 'Tried to get stream from the webcam/microphone, but no constraints were specified.';
$string['gumtype_title'] = 'No constraints specified';
$string['insecurealert'] = 'Your browser might not allow this plugin to work unless it is used either over HTTPS or from localhost.';
$string['insecurealert_title'] = 'Insecure connection!';
$string['maxfilesizehit'] = 'You have reached the maximum size limit for file uploads.';
$string['maxfilesizehit_title'] = 'Recording stopped';
$string['norecordingfound'] = 'Something has gone wrong. Nothing has been recorded.';
$string['norecordingfound_title'] = 'No recording found';
$string['nowebrtc'] = 'Your browser offers limited or no support for WebRTC technologies yet, and can\'t be used with this plugin. Please switch or upgrade your browser.';
$string['nowebrtc_title'] = 'WebRTC not supported';
$string['onlyaudio'] = 'Audio only';
$string['onlyvideo'] = 'Video only';
$string['pluginname'] = 'RecordRTC';
$string['privacy:metadata'] = 'The RecordRTC plugin does not store any personal data.';
$string['recordagain'] = 'Record again';
$string['recordagain_desc'] = 'You have already recorded some content. Recording again will remove this content. Are you sure you want to reset the recording?';
$string['recordagain_title'] = 'Record again confirmation';
$string['recordingfailed'] = 'Recording failed. Try again.';
$string['recordinguploaded'] = 'Recording uploaded';
$string['recordrtc:recordaudio'] = 'Record audio in the text editor';
$string['recordrtc:recordvideo'] = 'Record video in the text editor';
$string['startrecording'] = 'Start recording';
$string['stoprecording'] = 'Stop recording';
$string['timelimitwarning'] = 'You must enter a number that is greater than 0.';
$string['uploadaborted'] = 'Upload aborted:';
$string['uploadfailed'] = 'Upload failed with error: {$a->error}';
$string['uploadfailed404'] = 'Upload failed: file too large';
$string['uploading'] = 'Uploading - {$a->progress}%';
$string['uploadprogress'] = 'completed';
$string['videobitrate'] = 'Video bitrate';
$string['videobitrate_desc'] = 'Quality of video recording (larger number means higher quality).';
$string['videobuttontitle'] = 'Record video';
$string['videotimelimit'] = 'Video time limit';
$string['videotimelimit_desc'] = 'Maximum recording length for video clips.';
$string['videotitle'] = 'Record video';
$string['helplinktext'] = 'RecordRTC';
