define("core/local/reactive/debug",["exports","core/local/reactive/reactive","core/log"],(function(_exports,_reactive,_log){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Reactive module debug tools.
   *
   * @module     core/local/reactive/debug
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.initDebug=void 0,_reactive=_interopRequireDefault(_reactive),_log=_interopRequireDefault(_log);const reactiveInstances={},reactiveDebuggers={};
/**
   * Reactive module debug tools.
   *
   * If debug is enabled, this reactive module will spy all the reactive instances and keep a record
   * of the changes and components they have.
   *
   * It is important to note that the Debug class is also a Reactive module. The debug instance keeps
   * the reactive instances data as its own state. This way it is possible to implement development tools
   * that whatches this data.
   *
   * @class      core/reactive/local/reactive/debug/Debug
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class Debug extends _reactive.default{setInitialState(stateData){super.setInitialState(stateData),_log.default.debug('Debug module "M.reactive" loaded.')}get list(){return JSON.parse(JSON.stringify(this.state.reactives))}registerNewInstance(instance){var _instance$name;let name=null!==(_instance$name=instance.name)&&void 0!==_instance$name?_instance$name:"instance".concat(this.state.reactives.length);name=name.replace(/\W/g,""),_log.default.debug('Registering new reactive instance "M.reactive.'.concat(name,'"')),reactiveInstances[name]=instance,reactiveDebuggers[name]=new DebugInstance(reactiveInstances[name]),this.dispatch("putInstance",name,instance);const refreshMethod=()=>{this.dispatch("putInstance",name,instance)};instance.target.addEventListener("readmode:on",refreshMethod),instance.target.addEventListener("readmode:off",refreshMethod),instance.target.addEventListener("registerComponent:success",refreshMethod),instance.target.addEventListener("transaction:end",refreshMethod);instance.target.addEventListener("transaction:start",(_ref=>{let{detail:detail}=_ref;const changes=null==detail?void 0:detail.changes;this.dispatch("lastTransaction",name,changes)}))}debug(name){return reactiveDebuggers[name]}}class Mutations{putInstance(stateManager,name,instance){const state=stateManager.state;stateManager.setReadOnly(!1),state.reactives.has(name)?(state.reactives.get(name).countcomponents=instance.components.length,state.reactives.get(name).readOnly=instance.stateManager.readonly,state.reactives.get(name).modified=(new Date).getTime()):state.reactives.add({id:name,countcomponents:instance.components.length,readOnly:instance.stateManager.readonly,lastChanges:[],modified:(new Date).getTime()}),stateManager.setReadOnly(!0)}lastTransaction(stateManager,name,changes){if(!changes||0===changes.length)return;const state=stateManager.state,lastChanges=["transaction:start"];changes.forEach((change=>{lastChanges.push(change.eventName)})),lastChanges.push("transaction:end"),stateManager.setReadOnly(!1),state.reactives.get(name).lastChanges=lastChanges,stateManager.setReadOnly(!0)}}
/**
   * Class used to debug a specific instance and manipulate the state from the JS console.
   *
   * @class      core/reactive/local/reactive/debug/DebugInstance
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */class DebugInstance{constructor(instance){this.instance=instance,void 0===instance._reactiveDebugData&&(instance._reactiveDebugData={highlighted:!1})}set readOnly(value){this.instance.stateManager.setReadOnly(value)}get readOnly(){return this.instance.stateManager.readonly}get state(){return this.instance.state}set highlight(value){this.instance._reactiveDebugData.highlighted=value,this.instance.components.forEach((_ref2=>{let{element:element}=_ref2;const border=value?"thick solid #0000FF":"";element.style.border=border}))}get highlight(){return this.instance._reactiveDebugData.highlighted}get components(){return[...this.instance.components]}get changes(){const result=[];return this.instance.stateManager.eventsToPublish.forEach((element=>{result.push(element.eventName)})),result}async dispatch(){this.instance.dispatch(...arguments)}get elements(){const result=[];return this.instance.components.forEach((_ref3=>{let{element:element}=_ref3;result.push(element)})),result}get stateData(){return JSON.parse(JSON.stringify(this.state))}processUpdates(updates){this.instance.stateManager.processUpdates(updates)}}function dispatchStateChangedEvent(detail,target){void 0===target&&(target=document),target.dispatchEvent(new CustomEvent("core_reactive_debug:stateChanged",{bubbles:!0,detail:detail}))}_exports.initDebug=()=>{const debug=new Debug({name:"CoreReactiveDebug",eventName:"core_reactive_debug:stateChanged",eventDispatch:dispatchStateChangedEvent,mutations:new Mutations,state:{reactives:[]}});return reactiveDebuggers.registerNewInstance=debug.registerNewInstance.bind(debug),{debug:debug,debuggers:reactiveDebuggers}}}));

//# sourceMappingURL=debug.min.js.map