﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['zh-cn']={"application":"富文本编辑器","editor":"编辑器","editorPanel":"所见即所得编辑器面板","common":{"editorHelp":"按 ALT+0 获得帮助","browseServer":"浏览服务器","url":"URL","protocol":"协议","upload":"上传","uploadSubmit":"上传到服务器","image":"图像","form":"表单","checkbox":"复选框","radio":"单选按钮","textField":"单行文本","textarea":"多行文本","hiddenField":"隐藏域","button":"按钮","select":"列表/菜单","imageButton":"图像按钮","notSet":"<没有设置>","id":"ID","name":"名称","langDir":"语言方向","langDirLtr":"从左到右 (LTR)","langDirRtl":"从右到左 (RTL)","langCode":"语言代码","longDescr":"详细说明 URL","cssClass":"样式类名称","advisoryTitle":"标题","cssStyle":"行内样式","ok":"确定","cancel":"取消","close":"关闭","preview":"预览","resize":"拖拽以改变大小","generalTab":"常规","advancedTab":"高级","validateNumberFailed":"需要输入数字格式","confirmNewPage":"当前文档内容未保存，是否确认新建文档？","confirmCancel":"部分修改尚未保存，是否确认关闭对话框？","options":"选项","target":"目标窗口","targetNew":"新窗口 (_blank)","targetTop":"整页 (_top)","targetSelf":"本窗口 (_self)","targetParent":"父窗口 (_parent)","langDirLTR":"从左到右 (LTR)","langDirRTL":"从右到左 (RTL)","styles":"样式","cssClasses":"样式类","width":"宽度","height":"高度","align":"对齐方式","left":"左对齐","right":"右对齐","center":"居中","justify":"两端对齐","alignLeft":"左对齐","alignRight":"右对齐","alignCenter":"居中","alignTop":"顶端","alignMiddle":"居中","alignBottom":"底部","alignNone":"无","invalidValue":"无效的值。","invalidHeight":"高度必须为数字格式","invalidWidth":"宽度必须为数字格式","invalidLength":"为 \"%1\" 字段设置的值必须是一个正数或者没有一个有效的度量单位 (%2)。","invalidCssLength":"此“%1”字段的值必须为正数，可以包含或不包含一个有效的 CSS 长度单位(px, %, in, cm, mm, em, ex, pt 或 pc)","invalidHtmlLength":"此“%1”字段的值必须为正数，可以包含或不包含一个有效的 HTML 长度单位(px 或 %)","invalidInlineStyle":"内联样式必须为格式是以分号分隔的一个或多个“属性名 : 属性值”。","cssLengthTooltip":"输入一个表示像素值的数字，或加上一个有效的 CSS 长度单位(px, %, in, cm, mm, em, ex, pt 或 pc)。","unavailable":"%1<span class=\"cke_accessibility\">，不可用</span>","keyboard":{"8":"退格键","13":"回车键","16":"Shift","17":"Ctrl","18":"Alt","32":"空格键","35":"行尾键","36":"行首键","46":"删除键","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"快捷键","optionDefault":"默认"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"版权所有 &copy; $1。<br />保留所有权利。","dlgTitle":"关于 CKEditor 4","moreInfo":"相关授权许可信息请访问我们的网站："},"basicstyles":{"bold":"加粗","italic":"倾斜","strike":"删除线","subscript":"下标","superscript":"上标","underline":"下划线"},"bidi":{"ltr":"文字方向为从左至右","rtl":"文字方向为从右至左"},"blockquote":{"toolbar":"块引用"},"notification":{"closed":"通知已关闭"},"toolbar":{"toolbarCollapse":"折叠工具栏","toolbarExpand":"展开工具栏","toolbarGroups":{"document":"文档","clipboard":"剪贴板/撤销","editing":"编辑","forms":"表单","basicstyles":"基本格式","paragraph":"段落","links":"链接","insert":"插入","styles":"样式","colors":"颜色","tools":"工具"},"toolbars":"工具栏"},"clipboard":{"copy":"复制","copyError":"您的浏览器安全设置不允许编辑器自动执行复制操作，请使用键盘快捷键(Ctrl/Cmd+C)来完成。","cut":"剪切","cutError":"您的浏览器安全设置不允许编辑器自动执行剪切操作，请使用键盘快捷键(Ctrl/Cmd+X)来完成。","paste":"粘贴","pasteNotification":"您的浏览器不支持通过工具栏或右键菜单进行粘贴，请按 %1 进行粘贴。","pasteArea":"粘贴区域","pasteMsg":"将您的内容粘贴到下方区域，然后按确定。","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"自动","bgColorTitle":"背景颜色","colors":{"000":"黑色","800000":"栗色","8B4513":"鞍褐色","2F4F4F":"深岩灰色","008080":"凫绿色","000080":"海军蓝色","4B0082":"靛色","696969":"深灰色","B22222":"火砖红色","A52A2A":"褐色","DAA520":"金菊色","006400":"深绿色","40E0D0":"绿松石色","0000CD":"中蓝色","800080":"紫色","808080":"灰色","F00":"红色","FF8C00":"深橙色","FFD700":"金色","008000":"绿色","0FF":"青色","00F":"蓝色","EE82EE":"紫罗兰色","A9A9A9":"暗灰色","FFA07A":"浅鲑红色","FFA500":"橙色","FFFF00":"黄色","00FF00":"鲜绿色","AFEEEE":"灰绿松石色","ADD8E6":"浅蓝色","DDA0DD":"梅红色","D3D3D3":"浅灰色","FFF0F5":"薰衣草紫红色","FAEBD7":"古董白色","FFFFE0":"浅黄色","F0FFF0":"蜜瓜绿色","F0FFFF":"浅蓝色","F0F8FF":"爱丽丝蓝色","E6E6FA":"薰衣草紫色","FFF":"白色","1ABC9C":"浓青色","2ECC71":"碧绿色","3498DB":"亮蓝色","9B59B6":"紫水晶色","4E5F70":"灰蓝色","F1C40F":"鲜黄色","16A085":"深青色","27AE60":"深碧绿色","2980B9":"浓蓝色","8E44AD":"深紫罗兰色","2C3E50":"不饱和蓝色","F39C12":"橙色","E67E22":"红萝卜红色","E74C3C":"灰红色","ECF0F1":"亮银色","95A5A6":"浅灰青色","DDD":"浅灰色","D35400":"南瓜黄色","C0392B":"浓红色","BDC3C7":"银色","7F8C8D":"灰青色","999":"深灰色"},"more":"其它颜色...","panelTitle":"颜色","textColorTitle":"文本颜色"},"colordialog":{"clear":"清除","highlight":"高亮","options":"颜色选项","selected":"选择颜色","title":"选择颜色"},"templates":{"button":"模板","emptyListMsg":"(没有模板)","insertOption":"替换当前内容","options":"模板选项","selectPromptMsg":"请选择要在编辑器中使用的模板：","title":"内容模板"},"contextmenu":{"options":"快捷菜单选项"},"copyformatting":{"label":"格式刷","notification":{"copied":"格式已复制","applied":"格式已应用","canceled":"格式已取消","failed":"格式化失败，您不能还没复制就应用格式"}},"div":{"IdInputLabel":"ID","advisoryTitleInputLabel":"标题","cssClassInputLabel":"样式类名称","edit":"编辑 DIV","inlineStyleInputLabel":"行内样式","langDirLTRLabel":"从左到右 (LTR)","langDirLabel":"语言方向","langDirRTLLabel":"从右到左 (RTL)","languageCodeInputLabel":"语言代码","remove":"移除 DIV","styleSelectLabel":"样式","title":"创建 DIV 容器","toolbar":"创建 DIV 容器"},"elementspath":{"eleLabel":"元素路径","eleTitle":"%1 元素"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"读取文件时发生错误","networkError":"上传文件时发生网络错误","httpError404":"上传文件时发生 HTTP 错误（404：无法找到文件）","httpError403":"上传文件时发生 HTTP 错误（403：禁止访问）","httpError":"上传文件时发生 HTTP 错误（错误代码：%1）","noUrlError":"上传的 URL 未定义","responseError":"不正确的服务器响应"},"find":{"find":"查找","findOptions":"查找选项","findWhat":"查找:","matchCase":"区分大小写","matchCyclic":"循环匹配","matchWord":"全字匹配","notFoundMsg":"指定的文本没有找到。","replace":"替换","replaceAll":"全部替换","replaceSuccessMsg":"共完成 %1 处替换。","replaceWith":"替换:","title":"查找和替换"},"font":{"fontSize":{"label":"大小","voiceLabel":"文字大小","panelTitle":"大小"},"label":"字体","panelTitle":"字体","voiceLabel":"字体"},"fakeobjects":{"anchor":"锚点","hiddenfield":"隐藏域","iframe":"IFrame","unknown":"未知对象"},"forms":{"button":{"title":"按钮属性","text":"标签(值)","type":"类型","typeBtn":"按钮","typeSbm":"提交","typeRst":"重设"},"checkboxAndRadio":{"checkboxTitle":"复选框属性","radioTitle":"单选按钮属性","value":"选定值","selected":"已勾选","required":"必选项"},"form":{"title":"表单属性","menu":"表单属性","action":"动作","method":"方法","encoding":"表单编码"},"hidden":{"title":"隐藏域属性","name":"名称","value":"初始值"},"select":{"title":"菜单/列表属性","selectInfo":"选择信息","opAvail":"可选项","value":"值","size":"高度","lines":"行","chkMulti":"允许多选","required":"必选项","opText":"选项文本","opValue":"选项值","btnAdd":"添加","btnModify":"修改","btnUp":"上移","btnDown":"下移","btnSetValue":"设为初始选定","btnDelete":"删除"},"textarea":{"title":"多行文本属性","cols":"字符宽度","rows":"行数"},"textfield":{"title":"单行文本属性","name":"名称","value":"初始值","charWidth":"字符宽度","maxChars":"最多字符数","required":"必填项","type":"类型","typeText":"文本","typePass":"密码","typeEmail":"Email","typeSearch":"搜索","typeTel":"电话号码","typeUrl":"地址"}},"format":{"label":"格式","panelTitle":"格式","tag_address":"地址","tag_div":"段落(DIV)","tag_h1":"标题 1","tag_h2":"标题 2","tag_h3":"标题 3","tag_h4":"标题 4","tag_h5":"标题 5","tag_h6":"标题 6","tag_p":"普通","tag_pre":"已编排格式"},"horizontalrule":{"toolbar":"插入水平线"},"iframe":{"border":"显示框架边框","noUrl":"请输入框架的 URL","scrolling":"允许滚动条","title":"IFrame 属性","toolbar":"IFrame","tabindex":"Remove from tabindex"},"image":{"alt":"替换文本","border":"边框大小","btnUpload":"上传到服务器","button2Img":"确定要把当前图像按钮转换为普通图像吗？","hSpace":"水平间距","img2Button":"确定要把当前图像改变为图像按钮吗？","infoTab":"图像信息","linkTab":"链接","lockRatio":"锁定比例","menu":"图像属性","resetSize":"原始尺寸","title":"图像属性","titleButton":"图像域属性","upload":"上传","urlMissing":"缺少图像源文件地址","vSpace":"垂直间距","validateBorder":"边框大小必须为整数格式","validateHSpace":"水平间距必须为整数格式","validateVSpace":"垂直间距必须为整数格式"},"indent":{"indent":"增加缩进量","outdent":"减少缩进量"},"smiley":{"options":"表情图标选项","title":"插入表情图标","toolbar":"表情符"},"language":{"button":"设置语言","remove":"移除语言"},"link":{"acccessKey":"访问键","advanced":"高级","advisoryContentType":"内容类型","advisoryTitle":"标题","anchor":{"toolbar":"插入/编辑锚点链接","menu":"锚点链接属性","title":"锚点链接属性","name":"锚点名称","errorName":"请输入锚点名称","errorWhitespace":"Anchor name cannot contain space characters","remove":"删除锚点"},"anchorId":"按锚点 ID","anchorName":"按锚点名称","charset":"字符编码","cssClasses":"样式类名称","download":"强制下载","displayText":"显示文本","emailAddress":"地址","emailBody":"内容","emailSubject":"主题","id":"ID","info":"超链接信息","langCode":"语言代码","langDir":"语言方向","langDirLTR":"从左到右 (LTR)","langDirRTL":"从右到左 (RTL)","menu":"编辑超链接","name":"名称","noAnchors":"(此文档没有可用的锚点)","noEmail":"请输入电子邮件地址","noUrl":"请输入超链接地址","noTel":"请输入电话号码","other":"<其他>","phoneNumber":"电话号码","popupDependent":"依附 (NS)","popupFeatures":"弹出窗口属性","popupFullScreen":"全屏 (IE)","popupLeft":"左","popupLocationBar":"地址栏","popupMenuBar":"菜单栏","popupResizable":"可缩放","popupScrollBars":"滚动条","popupStatusBar":"状态栏","popupToolbar":"工具栏","popupTop":"右","rel":"关联","selectAnchor":"选择一个锚点","styles":"行内样式","tabIndex":"Tab 键次序","target":"目标","targetFrame":"<框架>","targetFrameName":"目标框架名称","targetPopup":"<弹出窗口>","targetPopupName":"弹出窗口名称","title":"超链接","toAnchor":"页内锚点链接","toEmail":"电子邮件","toUrl":"地址","toPhone":"电话","toolbar":"插入/编辑超链接","type":"超链接类型","unlink":"取消超链接","upload":"上传"},"list":{"bulletedlist":"项目列表","numberedlist":"编号列表"},"liststyle":{"bulletedTitle":"项目列表属性","circle":"空心圆","decimal":"数字 (1, 2, 3, 等)","disc":"实心圆","lowerAlpha":"小写英文字母(a, b, c, d, e, 等)","lowerRoman":"小写罗马数字(i, ii, iii, iv, v, 等)","none":"无标记","notset":"<没有设置>","numberedTitle":"编号列表属性","square":"实心方块","start":"开始序号","type":"标记类型","upperAlpha":"大写英文字母(A, B, C, D, E, 等)","upperRoman":"大写罗马数字(I, II, III, IV, V, 等)","validateStartNumber":"列表开始序号必须为整数格式"},"magicline":{"title":"在这插入段落"},"maximize":{"maximize":"全屏","minimize":"最小化"},"newpage":{"toolbar":"新建"},"pagebreak":{"alt":"分页符","toolbar":"插入打印分页符"},"pastetext":{"button":"粘贴为无格式文本","pasteNotification":"您的浏览器不支持通过工具栏或右键菜单进行粘贴，请按 %1 进行粘贴。","title":"粘贴为无格式文本"},"pastefromword":{"confirmCleanup":"您要粘贴的内容好像是来自 MS Word，是否要清除 MS Word 格式后再粘贴？","error":"由于内部错误无法清理要粘贴的数据","title":"从 MS Word 粘贴","toolbar":"从 MS Word 粘贴"},"preview":{"preview":"预览"},"print":{"toolbar":"打印"},"removeformat":{"toolbar":"清除格式"},"save":{"toolbar":"保存"},"selectall":{"toolbar":"全选"},"showblocks":{"toolbar":"显示区块"},"sourcearea":{"toolbar":"源码"},"specialchar":{"options":"特殊符号选项","title":"选择特殊符号","toolbar":"插入特殊符号"},"scayt":{"btn_about":"关于即时拼写检查","btn_dictionaries":"字典","btn_disable":"禁用即时拼写检查","btn_enable":"启用即时拼写检查","btn_langs":"语言","btn_options":"选项","text_title":"即时拼写检查"},"stylescombo":{"label":"样式","panelTitle":"样式","panelTitle1":"块级元素样式","panelTitle2":"内联元素样式","panelTitle3":"对象元素样式"},"table":{"border":"边框","caption":"标题","cell":{"menu":"单元格","insertBefore":"在左侧插入单元格","insertAfter":"在右侧插入单元格","deleteCell":"删除单元格","merge":"合并单元格","mergeRight":"向右合并单元格","mergeDown":"向下合并单元格","splitHorizontal":"水平拆分单元格","splitVertical":"垂直拆分单元格","title":"单元格属性","cellType":"单元格类型","rowSpan":"纵跨行数","colSpan":"横跨列数","wordWrap":"自动换行","hAlign":"水平对齐","vAlign":"垂直对齐","alignBaseline":"基线","bgColor":"背景颜色","borderColor":"边框颜色","data":"数据","header":"表头","columnHeader":"Column Header","rowHeader":"Row Header","yes":"是","no":"否","invalidWidth":"单元格宽度必须为数字格式","invalidHeight":"单元格高度必须为数字格式","invalidRowSpan":"行跨度必须为整数格式","invalidColSpan":"列跨度必须为整数格式","chooseColor":"选择"},"cellPad":"边距","cellSpace":"间距","column":{"menu":"列","insertBefore":"在左侧插入列","insertAfter":"在右侧插入列","deleteColumn":"删除列"},"columns":"列数","deleteTable":"删除表格","headers":"标题单元格","headersBoth":"第一列和第一行","headersColumn":"第一列","headersNone":"无","headersRow":"第一行","heightUnit":"高度单位","invalidBorder":"边框粗细必须为数字格式","invalidCellPadding":"单元格填充必须为数字格式","invalidCellSpacing":"单元格间距必须为数字格式","invalidCols":"指定的行数必须大于零","invalidHeight":"表格高度必须为数字格式","invalidRows":"指定的列数必须大于零","invalidWidth":"表格宽度必须为数字格式","menu":"表格属性","row":{"menu":"行","insertBefore":"在上方插入行","insertAfter":"在下方插入行","deleteRow":"删除行"},"rows":"行数","summary":"摘要","title":"表格属性","toolbar":"表格","widthPc":"百分比","widthPx":"像素","widthUnit":"宽度单位"},"undo":{"redo":"重做","undo":"撤消"},"widget":{"move":"点击并拖拽以移动","label":"%1 小部件"},"uploadwidget":{"abort":"上传已被用户中止","doneOne":"文件上传成功","doneMany":"成功上传了 %1 个文件","uploadOne":"正在上传文件（{percentage}%）...","uploadMany":"正在上传文件，{max} 中的 {current}（{percentage}%）..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"源码","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"搜索表情...","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"表情清单","groups":{"people":"笑脸和人物","nature":"自然和动物","food":"食物和饮料","travel":"旅游和地方","activities":"活动和行为","objects":"物品和对象","symbols":"符号和标志","flags":"国旗和旗帜"}},"html5video":{"button":"发布HTML5视频","title":"HTML5视频","infoLabel":"视频信息","allowed":"支持格式: MP4, WebM, Ogv","urlMissing":"视频url","videoProperties":"视频属性","upload":"上传视频","btnUpload":"上传","advanced":"高级","autoplay":"自动播放","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"是","no":"否","responsive":"自动宽度","controls":"显示控件？","loop":"Loop?","poster":"Thumbnail"},"sourcedialog":{"toolbar":"源码","title":"源码"}};